/** !------------------------------------------------------------------------->
*
*  @file <BusConfiguration>_tx.h
*
*  @creationDate 22 November 2024 14:08:31
*
*  @brief 
*    This is a generated BusCfg_tx header file for manual and cyclis PDU triggering.
*    Any changes will be lost, during the next generation cycle
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2024, dSPACE GmbH. All rights reserved.
*   
*!-------------------------------------------------------------------------->*/


#pragma once



EXTERN_C_DECL volatile sint64 Bus_Configuration__1__11337_BusCfg_CurrentTime;

EXTERN_C_DECL BusCfgTxPdu Bus_Configuration__1__11337_BusCfgTxPdus[];

#define Com_TX_AngVel_Compressor_11217_10692_11337 0
#define Com_TX_cmd_battery_pump_11216_10693_11337 1
#define Com_TX_cmd_chiller_bypass_11215_10693_11337 2
#define Com_TX_cmd_comp_11214_10693_11337 3
#define Com_TX_cmd_fan_11213_10693_11337 4
#define Com_TX_cmd_heater_11212_10693_11337 5
#define Com_TX_cmd_motor_pump_11211_10693_11337 6
#define Com_TX_cmd_parallel_serial_11210_10693_11337 7
#define Com_TX_cmd_rad_bypass_11209_10693_11337 8
#define Com_TX_EPower_Compressor_11208_10692_11337 9
#define Com_TX_i_battery_11207_10692_11337 10
#define Com_TX_I_traction_11206_10693_11337 11
#define Com_TX_p_chiller_11205_10692_11337 12
#define Com_TX_p_cond_11204_10692_11337 13
#define Com_TX_PJoule_battery_11203_10692_11337 14
#define Com_TX_Q_charger_11202_10693_11337 15
#define Com_TX_Q_dcdc_11201_10693_11337 16
#define Com_TX_Q_inverter_11200_10693_11337 17
#define Com_TX_Q_motor_11199_10693_11337 18
#define Com_TX_T_battery1_11198_10692_11337 19
#define Com_TX_T_battery2_11197_10692_11337 20
#define Com_TX_T_battery3_11196_10692_11337 21
#define Com_TX_T_battery4_11195_10692_11337 22
#define Com_TX_T_coolant_battery_in_11194_10692_11337 23
#define Com_TX_T_coolant_inverter_out_11193_10692_11337 24
#define Com_TX_T_inverter_11192_10692_11337 25
#define Com_TX_T_motor_11191_10692_11337 26
#define Com_TX_Torque_Compressor_11190_10692_11337 27
#define Com_TX_v_vehicle_11189_10693_11337 28

/**************************************************************************************************\
 *** FUNCTION:
 ***     Bus_Configuration__1__11337_BusCfgTx_OnStart
 *** 
 *** DESCRIPTION:
 ***     This function is called in OnStart application phase.
 ***
 *** PARAMETERS:
 ***     -/-
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
EXTERN_C_DECL void Bus_Configuration__1__11337_BusCfgTx_OnStart(void);

/**************************************************************************************************\
 *** FUNCTION:
 ***     Bus_Configuration__1__11337_BusCfgTx_OnStop
 *** 
 *** DESCRIPTION:
 ***     This function is called in OnStop application phase.
 ***
 *** PARAMETERS:
 ***     -/-
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
EXTERN_C_DECL void Bus_Configuration__1__11337_BusCfgTx_OnStop(void);

/**************************************************************************************************\
 *** FUNCTION:
 ***     Bus_Configuration__1__11337_BusCfgTx_VariableInitialize()
 *** 
 *** DESCRIPTION:
 ***    This function is called before the application starts and may be used to extend the
 ***    initialization phase.
 ***
 *** PARAMETERS:
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
EXTERN_C_DECL void Bus_Configuration__1__11337_BusCfgTx_VariableInitialize(void);

/**************************************************************************************************\
 *** FUNCTION:
 ***     Bus_Configuration__1__11337_BusCfgTx_SetPduPeriodOffset()
 *** 
 *** DESCRIPTION:
 ***    This function is called if the value of period or offset of a CyclicTimingControl 
 ***    feature change.
 ***
 *** PARAMETERS:
 ***    PduIdType pduId        Identifier of the PDU
 ***    sint32    period       New periof value of the PDU
 ***    sint32    offset       New offet of the PDU
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
EXTERN_C_DECL void Bus_Configuration__1__11337_BusCfgTx_SetPduPeriodOffset(PduIdType pduId, sint32 period, sint32 offset);

/**************************************************************************************************\
 *** FUNCTION:
 ***    Bus_Configuration__1__11337_BusCfgTx_SetPduPending
 *** 
 *** DESCRIPTION:
 ***    This function adds a new entry to trigger cache sorted by message priority
 ***
 *** PARAMETERS:
 ***    PduIdType pduId        Identifier of the PDU
 *** 
 *** RETURNS:
 ***     E_OK on success, E_NOT_OK if cache is full
\**************************************************************************************************/
EXTERN_C_DECL Std_ReturnType Bus_Configuration__1__11337_BusCfgTx_SetPduPending(PduIdType pduId);

/**************************************************************************************************\
 *** FUNCTION:
 ***     Bus_Configuration__1__11337_BusCfgTx_TriggerPendingPdus()
 *** 
 *** DESCRIPTION:
 ***    This function is called to set pending flag of specified PDU.
 ***
 *** PARAMETERS:
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
EXTERN_C_DECL void Bus_Configuration__1__11337_BusCfgTx_TriggerPendingPdus(void);

